<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => 'D:\\sources\\amelco_web\\www/templates/it_insightfx/particles/circle-progress.yaml',
    'modified' => 1524210884,
    'data' => [
        'name' => 'Circle Progress',
        'description' => 'Display circle progress.',
        'type' => 'particle',
        'configuration' => [
            'caching' => [
                'type' => 'static'
            ]
        ],
        'form' => [
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable Circle Progress particles.',
                    'default' => true
                ],
                'mainheading' => [
                    'type' => 'input.text',
                    'label' => 'Title',
                    'description' => 'Type in the title.',
                    'placeholder' => 'Enter Title',
                    'default' => ''
                ],
                'introtext' => [
                    'type' => 'textarea.textarea',
                    'label' => 'Intro Text',
                    'description' => 'Type in the intro text.',
                    'placeholder' => 'Enter Intro Text',
                    'default' => ''
                ],
                'animation' => [
                    'type' => 'select.select',
                    'label' => 'Animation',
                    'description' => 'Select when the animation should start.',
                    'placeholder' => 'Select...',
                    'default' => 'onload',
                    'options' => [
                        'onload' => 'On Page Load',
                        'viewport' => 'In Viewport'
                    ]
                ],
                'css.class' => [
                    'type' => 'input.selectize',
                    'label' => 'CSS Classes',
                    'description' => 'CSS class name for the particle.',
                    'default' => NULL
                ],
                'extra' => [
                    'type' => 'collection.keyvalue',
                    'label' => 'Tag Attributes',
                    'description' => 'Extra Tag attributes.',
                    'key_placeholder' => 'Key (data-*, style, ...)',
                    'value_placeholder' => 'Value',
                    'exclude' => [
                        0 => 'id',
                        1 => 'class'
                    ]
                ],
                'items' => [
                    'type' => 'collection.list',
                    'array' => true,
                    'label' => 'Circle Progress Items',
                    'description' => 'Create each Circle Progress item to display.',
                    'value' => 'name',
                    'ajax' => true,
                    'fields' => [
                        '.value' => [
                            'type' => 'input.text',
                            'label' => 'Value',
                            'description' => 'This is the only required option. It should be from \'0.0\' to \'1.0\'.',
                            'default' => '0.8'
                        ],
                        '.size' => [
                            'type' => 'input.text',
                            'label' => 'Size',
                            'description' => 'Set the size of the circle in pixels (do NOT type in \'px\', enter just the digits). Default is \'100\'.',
                            'default' => '100'
                        ],
                        '.thickness' => [
                            'type' => 'input.text',
                            'label' => 'Thickness',
                            'description' => 'Set the width of the arc in pixels (do NOT type in \'px\', enter just the digits). By default it is automatically calculated as 1/14 of \'Size\' but you may set your own number. Default is \'auto\'.',
                            'default' => 'auto'
                        ],
                        '.emptyfill' => [
                            'type' => 'input.colorpicker',
                            'label' => 'Empty Color',
                            'description' => 'Select the color of the \'empty\' arc.',
                            'default' => 'rgba(0, 0, 0, 0.1)'
                        ],
                        '.color1' => [
                            'type' => 'input.colorpicker',
                            'label' => 'Fill Color 1',
                            'description' => 'Select the arc fill color. You can choose two colors so you can achieve a gradient effect. Or you can set both colors to the same value in order to achieve a solid color.',
                            'default' => '#3aeabb'
                        ],
                        '.color2' => [
                            'type' => 'input.colorpicker',
                            'label' => 'Fill Color 2',
                            'description' => 'Select the arc fill color. You can choose two colors so you can achieve a gradient effect. Or you can set both colors to the same value in order to achieve a solid color.',
                            'default' => '#fdd250'
                        ],
                        '.title' => [
                            'type' => 'input.text',
                            'label' => 'Title'
                        ],
                        '.description' => [
                            'type' => 'textarea.textarea',
                            'label' => 'Description'
                        ],
                        '.class' => [
                            'type' => 'input.selectize',
                            'label' => 'CSS Class'
                        ],
                        '.extra' => [
                            'type' => 'collection.keyvalue',
                            'label' => 'Tag Attributes',
                            'description' => 'Extra Tag attributes.',
                            'key_placeholder' => 'Key (data-*, style, ...)',
                            'value_placeholder' => 'Value',
                            'exclude' => [
                                0 => 'id',
                                1 => 'class'
                            ]
                        ]
                    ]
                ]
            ]
        ]
    ]
];
